/////////////////////////////////////////////////////////////
// CINEMA SDK : COMMANDS																	 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_COMMANDDATA_H
#define __C4D_COMMANDDATA_H

#include "c4d_basedata.h"

class String;
class BaseContainer;
class BaseDocument;
class BaseBitmap;

struct RestoreLayoutSecret
{
	LONG subid;	
};


class CommandData : public BaseData
{
	public:
		virtual Bool Execute(BaseDocument *doc);
		virtual LONG GetState(BaseDocument *doc);
		virtual Bool RestoreLayout(void *secret);

		// for BP "PLUGIN_MESSAGE_xxx:messagetext" messages
		virtual void Message(const BaseContainer &msg);
};

Bool RegisterCommandPlugin(LONG id, const String &str, LONG info, const String &help, CommandData *dat);
Bool RegisterCommandPlugin(LONG id, const String &str, LONG info, BaseBitmap *icon, const String &help, CommandData *dat);
Bool RegisterCommandPlugin(LONG id, const String &str, LONG info, String icon, const String &help, CommandData *dat);

#endif
